const mongoose = require("mongoose");
const slugify = require("slugify");

const partnerSchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, "A partner must have a name"],
      unique: true,
      trim: true,
    },
    slug: String,
    image: {
      type: String,
      required: [true, "A partner must have a logo/image"],
    },
    // Optional fields
    subtitle: {
      type: String,
      trim: true,
    },
    description: {
      type: String,
      trim: true,
    },
  },
  {
    timestamps: true,
  }
);

// Middleware to create slug from name
partnerSchema.pre("save", function (next) {
  if (this.name) {
    this.slug = slugify(this.name, { lower: true });
  }
  next();
});

const Partner = mongoose.model("Partner", partnerSchema);
module.exports = Partner;
